// BroadcomInterfaceTestAppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NicCPApplet.h"
#include "NicCPAppDlg.h"
#include "DebugDlg.h"
#include "Advanced.h"
#include "Networkinfo.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


DWORD WINAPI ConnectThread(LPVOID lpParameter);
DWORD WINAPI CloseDeviceThread(LPVOID lpParameter);



DEFINE_GUID(GUID_NDIS_LAN_CLASS,  0xad498944, 0x762f, 0x11d0, 0x8d, 0xcb, 0x00, 0xc0, 0x4f, 0xc3, 0x35, 0x8c);


static TCHAR        DeviceName[MAX_PATH];

//
// Global data
//
CDebugDlg*		pDebugDlg;
CAdvanced*		pAdvancedDlg;
CNetworkinfo*	pNetworkInfoDlg;

ConfigData		confData;

BOOL		Autoconnect;
BOOL		Waitfordcdgoing1;
BOOL		AutoReconnect;
BOOL		_7dot2 = FALSE;

HANDLE		hFile;

CRITICAL_SECTION CriticalSection;




/////////////////////////////////////////////////////////////////////////////
// CNicCPAppDlg dialog

CNicCPAppDlg::CNicCPAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNicCPAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNicCPAppDlg)
	m_UserName = _T("");
	m_APNStr = _T("");
	m_PasswordStr = _T("");
	m_PINStr = _T("");
	m_APNStatic = _T("");
	m_PasswordStatic = _T("");
	m_PinStatic = _T("");
	m_USerNameStatic = _T("");
	m_StatusStatic = _T("");
	m_StatusString = _T("");
	m_ReasonStatic = _T("");
	m_SecretInt = 0;
	m_SecretStatic = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDI_BIGICON);
}

void CNicCPAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNicCPAppDlg)
	DDX_Control(pDX, IDC_SECRET, m_SecretCtl);
	DDX_Control(pDX, IDC_STATUSOUT, m_StatusCtl);
	DDX_Control(pDX, IDC_APPLY, m_Apply);
	DDX_Control(pDX, IDC_WCONNECTSTRINGS, m_WriteConfigCtl);
	DDX_Control(pDX, IDC_NETWORKDATA, m_NetworkInfoCtl);
	DDX_Control(pDX, IDC_DEBUG, m_DebugTraceCtl);
	DDX_Control(pDX, IDC_ADVANCED, m_AdvancedCtl);
	DDX_Control(pDX, IDC_CONNECT, m_ConnectCtl);
	DDX_Control(pDX, IDC_DISCONNECT, m_DisconnectCtl);
	DDX_Control(pDX, IDC_APN, m_APNCtl);
	DDX_Control(pDX, IDC_PIN, m_PINCtl);
	DDX_Control(pDX, IDC_PASSWORD, m_PassWordCtl);
	DDX_Control(pDX, IDC_USERNAME, m_UserNameCtl);
	DDX_Text(pDX, IDC_USERNAME, m_UserName);
	DDX_Text(pDX, IDC_APN, m_APNStr);
	DDX_Text(pDX, IDC_PASSWORD, m_PasswordStr);
	DDX_Text(pDX, IDC_PIN, m_PINStr);
	DDX_Text(pDX, IDC_STATICAPN, m_APNStatic);
	DDX_Text(pDX, IDC_STATICPASSWORD, m_PasswordStatic);
	DDX_Text(pDX, IDC_STATICPINNUMBER, m_PinStatic);
	DDX_Text(pDX, IDC_STATICUSERNAME, m_USerNameStatic);
	DDX_Text(pDX, IDC_STATUSSTATIC, m_StatusStatic);
	DDX_Text(pDX, IDC_STATUSOUT, m_StatusString);
	DDX_Text(pDX, IDC_REASONSTATIC, m_ReasonStatic);
	DDX_Text(pDX, IDC_SECRET, m_SecretInt);
	DDV_MinMaxDWord(pDX, m_SecretInt, 0, 4294967295);
	DDX_Text(pDX, IDC_STATICSECRET, m_SecretStatic);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNicCPAppDlg, CDialog)
	//{{AFX_MSG_MAP(CNicCPAppDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_DISCONNECT, OnDisconnect)
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	ON_BN_CLICKED(IDC_ADVANCED, OnAdvanced)
	ON_BN_CLICKED(IDC_NETWORKDATA, OnNetworkdata)
	ON_BN_CLICKED(IDC_DEBUG, OnDebug)
	ON_EN_CHANGE(IDC_PIN, OnChangePin)
	ON_EN_CHANGE(IDC_APN, OnChangeApn)
	ON_EN_CHANGE(IDC_USERNAME, OnChangeUsername)
	ON_EN_CHANGE(IDC_PASSWORD, OnChangePassword)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_MEASUREITEM()
	ON_BN_CLICKED(IDC_WCONNECTSTRINGS, OnOK)
	ON_MESSAGE(WM_READDATA, OnReadData) 
	ON_MESSAGE(WM_DEVICECHANGE, OnDeviceChange) 
	ON_MESSAGE(WM_KILL_DEBUG_POINTER, OnKillDebugpointer) 
	ON_EN_CHANGE(IDC_SECRET, OnChangeSecret)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNicCPAppDlg message handlers

BOOL CNicCPAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	keeprunning = true;
	hFile = NULL;
	CString		str;

	m_PINChanged = false;
	m_APNChanged = false;
	m_UsernameChanged = false;
	m_PasswordChanged = false;
	m_SecretChanged = false;
	m_hDevice = NULL;

	//
	// update the GUI from the string table
	//
	this->m_APNStatic.LoadString(IDS_APN);
	this->m_PasswordStatic.LoadString(IDS_PASSWORD	);
	this->m_PinStatic.LoadString(IDS_PINNUMBER);
	this->m_USerNameStatic.LoadString(IDS_USERNAME);
	this->m_StatusStatic.LoadString(IDS_STATUS);
	this->m_ReasonStatic.LoadString(IDS_REASON);
	this->m_SecretStatic.LoadString(IDS_CHAPSECRET);


	str.LoadString(IDS_OK);
	m_WriteConfigCtl.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_NETWORKINFO);
	m_NetworkInfoCtl.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_TRACE);
	m_DebugTraceCtl.SetWindowText((LPCTSTR)str);
	
	str.LoadString(IDS_ADVANCED);
	m_AdvancedCtl.SetWindowText((LPCTSTR)str);
	
	str.LoadString(IDS_RECONNECT);
	m_ConnectCtl.SetWindowText((LPCTSTR)str);
	
	str.LoadString(IDS_DISCONNECT);
	m_DisconnectCtl.SetWindowText((LPCTSTR)str);
	
	str.LoadString(IDS_APPLY);
	m_Apply.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_WIRLESSWANCONFIGURATION);
	this->SetWindowText((LPCTSTR)str);



	UpdateData(FALSE);


	InitializeCriticalSection(&CriticalSection);



	ZeroMemory( &devNotification,	  sizeof(devNotification) );
	devNotification.dbcc_size		= sizeof(DEV_BROADCAST_DEVICEINTERFACE);
	devNotification.dbcc_devicetype	= DBT_DEVTYP_DEVICEINTERFACE;
	InterfaceGuid					= GUID_NDIS_LAN_CLASS;
	devNotification.dbcc_classguid	= InterfaceGuid;

	hInterfaceNotification = RegisterDeviceNotification(this->GetSafeHwnd(),  &devNotification,    DEVICE_NOTIFY_WINDOW_HANDLE);
	if(!hInterfaceNotification)
	{
		doerror();
	}


	EnumerateExistingDevices(&GUID_NDIS_LAN_CLASS);

	return TRUE; 
}


VOID CNicCPAppDlg::EnumerateExistingDevices(const GUID* guid)
{						
	HDEVINFO info = SetupDiGetClassDevs((GUID*) guid, NULL, NULL, DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
	
	DEV_BROADCAST_HANDLE filter={0};

	if (info == INVALID_HANDLE_VALUE)
		return;

	SP_INTERFACE_DEVICE_DATA ifdata;

	ifdata.cbSize = sizeof(ifdata);


	DWORD devindex;

	for (devindex = 0; SetupDiEnumDeviceInterfaces(info, NULL, (GUID*) guid, devindex, &ifdata); ++devindex)
	{						// for each device
		DWORD needed;

		SetupDiGetDeviceInterfaceDetail(info, &ifdata, NULL, 0, &needed, NULL);

		PSP_INTERFACE_DEVICE_DETAIL_DATA detail = (PSP_INTERFACE_DEVICE_DETAIL_DATA) malloc(needed);

		if (!detail)
			continue;

		detail->cbSize = sizeof(SP_INTERFACE_DEVICE_DETAIL_DATA);
		
		if (!SetupDiGetDeviceInterfaceDetail(info, &ifdata, detail, needed, NULL, NULL))
		{						// can't get detail info
			free((PVOID) detail);
			continue;
		}						


		if(GetDeviceDescription(detail->DevicePath, DeviceName))
		{
			if(   (strstr(DeviceName, "GlobeTrotter") > 0)  && (strstr(DeviceName, "Network") > 0)  && (strstr(DeviceName, "Scheduler") ==0)   )
			{
				// ony open one device
				if(m_hDevice == NULL)
				{
					m_hDevice = CreateFile(detail->DevicePath, MAXIMUM_ALLOWED   , 0, NULL, OPEN_EXISTING, 0, NULL);

					if(m_hDevice == INVALID_HANDLE_VALUE) 
					{
						doerror();
						break;
					}


					if( strstr(DeviceName, "HSxPA") > 0) 
						_7dot2 = TRUE;


					ZeroMemory(&filter,			sizeof(filter)); 
					filter.dbch_size			= sizeof(filter);
					filter.dbch_devicetype		= DBT_DEVTYP_HANDLE;
					filter.dbch_handle			= m_hDevice;
					hHandleNotification			= RegisterDeviceNotification(GetSafeHwnd(),  &filter,    DEVICE_NOTIFY_WINDOW_HANDLE);
					if(!hHandleNotification)
					{
						doerror();
					}

					CreateThread(NULL, 
									0, 
									&ConnectThread,    // thread function
									this,              // thread argument
									0,				   // creation option
									0);                // thread identifier

				}
			}
		}


		free((PVOID) detail);

	}	

	SetupDiDestroyDeviceInfoList(info);
}						


DWORD WINAPI ConnectThread(LPVOID lpParameter)
{
	CNicCPAppDlg * dlg = (CNicCPAppDlg *) lpParameter;
	

	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	while(dlg->keeprunning)
	{
		hFile = CreateFile("\\\\.\\GTNDIS0", MAXIMUM_ALLOWED   , 0, 0, OPEN_EXISTING, 0, 0);
		if(hFile != INVALID_HANDLE_VALUE)
		{
			// enable all the windows
			dlg->m_DisconnectCtl.EnableWindow();
			dlg->m_ConnectCtl.EnableWindow();
			dlg->m_AdvancedCtl.EnableWindow();
			dlg->m_NetworkInfoCtl.EnableWindow();
			dlg->m_APNCtl.EnableWindow();
			dlg->m_PINCtl.EnableWindow();

			if(!_7dot2)
			{
				dlg->m_PassWordCtl.EnableWindow();
				dlg->m_UserNameCtl.EnableWindow();
			}
			dlg->m_StatusCtl.EnableWindow();
			dlg->m_SecretCtl.EnableWindow();
			dlg->keeprunning = FALSE;


			// enable the trace dialog if running
			if(pDebugDlg)
			{
				pDebugDlg->m_RawAtCtl.EnableWindow();
				pDebugDlg->m_RawAtDataCtl.EnableWindow();

				pDebugDlg->keeprunning = FALSE;
				pDebugDlg->OnGettrace();
			}

			dlg->m_Timer = dlg->SetTimer(1, 500, 0);

			break;
		}

		Sleep(500);
	}

	::PostMessage(dlg->GetSafeHwnd(), WM_READDATA, 0, 0);

	return 0;
}


DWORD WINAPI CloseDeviceThread(LPVOID lpParameter)
{
	CNicCPAppDlg * dlg = (CNicCPAppDlg *) lpParameter;
	

	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	dlg->CloseDevice();
	return 0;
}


BOOL CNicCPAppDlg::DestroyWindow() 
{
	KillTimer(m_Timer);  

	// wind up our thread 
	keeprunning = false;
	Sleep(300);


	// destroy the debug dialog
	if(pDebugDlg)
	{
		pDebugDlg->keeprunning = false;
		Sleep(300);
		delete pDebugDlg;
	}


	if(pAdvancedDlg)
		delete pAdvancedDlg;



	if(pNetworkInfoDlg)
		delete pNetworkInfoDlg;


	UnregisterDeviceNotification(hInterfaceNotification);

	if(hHandleNotification != NULL)
		UnregisterDeviceNotification(hHandleNotification);
	

	// close the handle to the driver
	if(hFile && (hFile != INVALID_HANDLE_VALUE))
		CloseHandle(hFile);

	if(m_hDevice != NULL)
		CloseHandle(m_hDevice);
	
	DeleteCriticalSection(&CriticalSection);

	return CDialog::DestroyWindow();
}





void CNicCPAppDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CNicCPAppDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}







void CNicCPAppDlg::OnConnect() 
{
	DWORD		bytesback;

	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;


	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_CONNECT, NULL, 0, NULL, 0, &bytesback,NULL))
	{
		doerror(); 
	}

}

void CNicCPAppDlg::OnDisconnect() 
{
	DWORD bytesback;

	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;


	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_DISCONNECT, NULL, 0, NULL, 0, &bytesback,NULL))
	{
		doerror(); 
	}
}





void CNicCPAppDlg::doerror()
{
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	// Process any inserts in lpMsgBuf.
	// ...
	// Display the string.
	CString msg;
	msg.Format("GTMNICAPP: "  _T("Error  %s\n"), lpMsgBuf);
	OutputDebugString(msg);
	// Free the buffer.
	LocalFree( lpMsgBuf );

}





LRESULT CNicCPAppDlg::OnReadData(WPARAM a, LPARAM b)
{

	ULONG buf[3];
	DWORD bytesback;

	if(!hFile)
		return 0;

	if(hFile == INVALID_HANDLE_VALUE)
		return 0;

	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_GETORSET_CONNECT_CONFIG, 0, 0, buf, 3 * sizeof(ULONG), &bytesback,NULL))
	{
		doerror(); 
	}
	else
	{
		Autoconnect = buf[0];
		Waitfordcdgoing1 = buf[1];
		AutoReconnect = buf[2];
	}

	this->OnRconnectstrings();


	return 0;
}


void CNicCPAppDlg::OnRconnectstrings() 
{
	DWORD bytesback;

	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;

	memset(&confData, sizeof(ConfigData), 0);
	
	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_READ_CONFIGDATA, 0, 0, &confData, sizeof(ConfigData), &bytesback,NULL))
	{
		doerror(); 
	}
	else
	{
		RefreshData();
	}
}




void CNicCPAppDlg::RefreshData()
{

	// scan the just read data for any APN or PIN commands, and user password stuff.  if found, put the data 
	// in the relevant window
	this->m_APNStr = "";
	this->m_PINStr = "";
	this->m_PasswordStr = "";	
	this->m_UserName = "";
	this->m_SecretInt = 0;


	ScanForPINorAPNAndPutInWindow(&this->m_APNStr, &this->m_PINStr, confData.ConectionStrings.ConnectString1);
	ScanForPINorAPNAndPutInWindow(&this->m_APNStr, &this->m_PINStr, confData.ConectionStrings.ConnectString2);
	ScanForPINorAPNAndPutInWindow(&this->m_APNStr, &this->m_PINStr, confData.ConectionStrings.ConnectString3);
	ScanForPINorAPNAndPutInWindow(&this->m_APNStr, &this->m_PINStr, confData.ConectionStrings.ConnectString4);
	ScanForPINorAPNAndPutInWindow(&this->m_APNStr, &this->m_PINStr, confData.ConectionStrings.ConnectString5);
	ScanForPINorAPNAndPutInWindow(&this->m_APNStr, &this->m_PINStr, confData.ConectionStrings.ConnectString6);
	ScanForPINorAPNAndPutInWindow(&this->m_APNStr, &this->m_PINStr, confData.ConectionStrings.ConnectString7);
	


	if(strlen((char*)confData.ConnectionParam.Password) > 0)
		this->m_PasswordStr = confData.ConnectionParam.Password;


	if(strlen((char*)confData.ConnectionParam.UserName) > 0)
		this->m_UserName = confData.ConnectionParam.UserName;


	this->m_SecretInt = confData.ConectionStrings.Secret;


	this->UpdateData(FALSE);

}







void CNicCPAppDlg::OnWconnectstrings() 
{
	ULONG buf[3];
	DWORD	bytesback;

	UpdateData(TRUE);

	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;


	buf[0] = Autoconnect;
	buf[1] = Waitfordcdgoing1;
	buf[2] = AutoReconnect;

	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_GETORSET_CONNECT_CONFIG, buf, 3 * sizeof(ULONG), 0, 0, &bytesback,NULL))
	{
		doerror(); 
	}


	if( m_APNChanged)
	{
		bool done= false;
		if(!done) done=ScanForAPNAndReplace(&this->m_APNStr, confData.ConectionStrings.ConnectString1);
		if(!done) done=ScanForAPNAndReplace(&this->m_APNStr, confData.ConectionStrings.ConnectString2);
		if(!done) done=ScanForAPNAndReplace(&this->m_APNStr, confData.ConectionStrings.ConnectString3);
		if(!done) done=ScanForAPNAndReplace(&this->m_APNStr, confData.ConectionStrings.ConnectString4);
		if(!done) done=ScanForAPNAndReplace(&this->m_APNStr, confData.ConectionStrings.ConnectString5);
		if(!done) done=ScanForAPNAndReplace(&this->m_APNStr, confData.ConectionStrings.ConnectString6);
		if(!done) done=ScanForAPNAndReplace(&this->m_APNStr, confData.ConectionStrings.ConnectString7);

		if(!done)
			CreateNewAPNEntry(&this->m_APNStr, &confData.ConectionStrings);
	}

	if( m_PINChanged)
	{
		bool done= false;
		if(!done) done=ScanForPINAndReplace(&this->m_PINStr, confData.ConectionStrings.ConnectString1);
		if(!done) done=ScanForPINAndReplace(&this->m_PINStr, confData.ConectionStrings.ConnectString2);
		if(!done) done=ScanForPINAndReplace(&this->m_PINStr, confData.ConectionStrings.ConnectString3);
		if(!done) done=ScanForPINAndReplace(&this->m_PINStr, confData.ConectionStrings.ConnectString4);
		if(!done) done=ScanForPINAndReplace(&this->m_PINStr, confData.ConectionStrings.ConnectString5);
		if(!done) done=ScanForPINAndReplace(&this->m_PINStr, confData.ConectionStrings.ConnectString6);
		if(!done) done=ScanForPINAndReplace(&this->m_PINStr, confData.ConectionStrings.ConnectString7);

		if(!done)
			CreateNewPINEntry(&this->m_PINStr, &confData.ConectionStrings);
	}
	if( m_UsernameChanged)
	{
		strcpy((char*)confData.ConnectionParam.UserName, this->m_UserName);
	}
	if(m_PasswordChanged)
	{
		strcpy((char*)confData.ConnectionParam.Password, this->m_PasswordStr);
	}

	if(m_SecretChanged)
	{
		confData.ConectionStrings.Secret = this->m_SecretInt;
	}
	
	
	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_WRITE_CONFIGDATA, &confData, sizeof(ConfigData), 0, 0, &bytesback,NULL))
	{
		doerror(); 
	}
}



void CNicCPAppDlg::OnDebug() 
{
	if(pDebugDlg)
	{
		pDebugDlg->keeprunning = false;
		Sleep(100);
		delete pDebugDlg;
	}

	pDebugDlg = NULL;

	pDebugDlg = new CDebugDlg;

	if(pDebugDlg)
		pDebugDlg->Create(IDD_DEBUG, this);
}




void CNicCPAppDlg::OnAdvanced() 
{

	OnRconnectstrings();


	if(pAdvancedDlg)
		delete pAdvancedDlg;

	pAdvancedDlg = NULL;

	pAdvancedDlg = new CAdvanced;

	if(pAdvancedDlg)
		pAdvancedDlg->Create(IDD_ADVANCED, this);

}

void CNicCPAppDlg::OnNetworkdata() 
{
	if(pNetworkInfoDlg)
		delete pNetworkInfoDlg;

	pNetworkInfoDlg = NULL;

	pNetworkInfoDlg = new CNetworkinfo;

	if(pNetworkInfoDlg)
		pNetworkInfoDlg->Create(IDD_NETWORKINFO);


}

void CNicCPAppDlg::OnOK() 
{
	OnWconnectstrings();
	CDialog::OnCancel();
}

void CNicCPAppDlg::OnCancel() 
{
	CDialog::OnCancel();
}


void CNicCPAppDlg::OnApply() 
{
	OnWconnectstrings();
}



void CNicCPAppDlg::ScanForPINorAPNAndPutInWindow(CString* a, CString* b, PUCHAR c)
{
	
	char* pos = strstr((char*)c, "AT+CPIN=\"");

	if(pos)
	{
		char* eqpos = pos + strlen("AT+CPIN=\"");

		*b = eqpos;
		
		char* caretpos = strchr((char*)c, '^');

		if(caretpos)
		{
			// go back to get rid of the " too
			caretpos--;

			b->TrimRight(caretpos);
		}
	}



	pos = strstr((char*)c, "AT+CGDCONT=1,\"IP\",\"");

	if(pos)
	{
		char* caretpos;
		char* APNpos;
		
		APNpos = pos + strlen("AT+CGDCONT=1,\"IP\",\"");
	
		*a = APNpos;
			
		caretpos = strchr((char*)c, '^');

		if(caretpos)
		{
			// go back to get rid of the " too
			caretpos--;

			a->TrimRight(caretpos);
		}
	}
}

bool CNicCPAppDlg::ScanForPINAndReplace(CString* a, PUCHAR c)
{
	CString temp;

	// get the part after the '^'
	char* caretpos = strchr((char*)c, '^');


	if(caretpos)
	{
		// include the " too
		caretpos--;

		temp = caretpos;
	}

	
	char* pos = strstr((char*)c, "AT+CPIN=\"");
	if(pos)
	{

		pos += strlen("AT+CPIN=\"");

		int len = a->GetLength();

		switch(len)
		{
		// no pin so delete the whole string
		case 0:
			*c = '\0';
			break;

		case 4:
			{
				*(pos+0) = a->GetAt(0);
				*(pos+1) = a->GetAt(1);
				*(pos+2) = a->GetAt(2);
				*(pos+3) = a->GetAt(3);
				*(pos+4) = '\0';

				strcat((char*)c,temp);

			}
			break;

//		default:
//			MessageBox(MAKEINTRESOURCE(IDS_INVALIDPIN), "Error", MB_OK);
		}
		return true;
	}
	return false;
}

bool CNicCPAppDlg::ScanForAPNAndReplace(CString* a, PUCHAR c)
{
	CString temp;

	// get the part after the '^'
	char* caretpos = strchr((char*)c, '^');


	if(caretpos)
	{
		// include the " too
		caretpos--;

		temp = caretpos;
	}
	

	
	char* pos = strstr((char*)c, "AT+CGDCONT=1,\"IP\",\"");
	if(pos)
	{
		pos += strlen("AT+CGDCONT=1,\"IP\",\"");

		int len1 = a->GetLength();

		switch(len1)
		{
		// empty APN so delete whole entry
		case 0:
			*c = '\0';
			break;

		default:
			{
				for(int i = 0 ; i < len1 ; i++)
				{
					*(pos+i) = a->GetAt(i);
				}
				
				*(pos+i) = '\0';

				strcat((char*)c,temp);

			}
			break;
		}
		return true;
	}
	return false;
}
	

void CNicCPAppDlg::CreateNewPINEntry(CString* a, PConnectionStrings c)
{
	if(a->GetLength() == 0)
		return;

	if(c->ConnectString1[0] == '\0')
	{
		strcpy((char*)c->ConnectString1, "AT+CPIN=\"");
		strcat((char*)c->ConnectString1, *a);
		strcat((char*)c->ConnectString1, "\"^OK~");
		return;
	}

	if(c->ConnectString2[0] == '\0')
	{
		strcpy((char*)c->ConnectString2, "AT+CPIN=\"");
		strcat((char*)c->ConnectString2, *a);
		strcat((char*)c->ConnectString2, "\"^OK~");
		return;
	}


	if(c->ConnectString3[0] == '\0')
	{
		strcpy((char*)c->ConnectString3, "AT+CPIN=\"");
		strcat((char*)c->ConnectString3, *a);
		strcat((char*)c->ConnectString3, "\"^OK~");
		return;
	}


	if(c->ConnectString4[0] == '\0')
	{
		strcpy((char*)c->ConnectString4, "AT+CPIN=\"");
		strcat((char*)c->ConnectString4, *a);
		strcat((char*)c->ConnectString4, "\"^OK~");
		return;
	}

	if(c->ConnectString5[0] == '\0')
	{
		strcpy((char*)c->ConnectString5, "AT+CPIN=\"");
		strcat((char*)c->ConnectString5, *a);
		strcat((char*)c->ConnectString5, "\"^OK~");
		return;
	}

	if(c->ConnectString6[0] == '\0')
	{
		strcpy((char*)c->ConnectString6, "AT+CPIN=\"");
		strcat((char*)c->ConnectString6, *a);
		strcat((char*)c->ConnectString6, "\"^OK~");
		return;
	}

	if(c->ConnectString7[0] == '\0')
	{
		strcpy((char*)c->ConnectString7, "AT+CPIN=\"");
		strcat((char*)c->ConnectString7, *a);
		strcat((char*)c->ConnectString7, "\"^OK~");
		return;
	}
//	MessageBox(MAKEINTRESOURCE(IDS_NOAVAILABLESTRINGSFPRPIN), "Error", MB_OK);
}



void CNicCPAppDlg::CreateNewAPNEntry(CString* a, PConnectionStrings c)
{
	if(c->ConnectString7[0] == '\0')
	{
		strcpy((char*)c->ConnectString7, "AT+CGDCONT=1,\"IP\",\"");
		strcat((char*)c->ConnectString7, *a);
		strcat((char*)c->ConnectString7, "\"^OK~");
		return;
	}

	if(c->ConnectString6[0] == '\0')
	{
		strcpy((char*)c->ConnectString6, "AT+CGDCONT=1,\"IP\",\"");
		strcat((char*)c->ConnectString6, *a);
		strcat((char*)c->ConnectString6, "\"^OK~");
		return;
	}
	if(c->ConnectString5[0] == '\0')
	{
		strcpy((char*)c->ConnectString5, "AT+CGDCONT=1,\"IP\",\"");
		strcat((char*)c->ConnectString5, *a);
		strcat((char*)c->ConnectString5, "\"^OK~");
		return;
	}
	if(c->ConnectString4[0] == '\0')
	{
		strcpy((char*)c->ConnectString4, "AT+CGDCONT=1,\"IP\",\"");
		strcat((char*)c->ConnectString4, *a);
		strcat((char*)c->ConnectString4, "\"^OK~");
		return;
	}
	if(c->ConnectString3[0] == '\0')
	{
		strcpy((char*)c->ConnectString3, "AT+CGDCONT=1,\"IP\",\"");
		strcat((char*)c->ConnectString3, *a);
		strcat((char*)c->ConnectString3, "\"^OK~");
		return;
	}
	if(c->ConnectString2[0] == '\0')
	{
		strcpy((char*)c->ConnectString2, "AT+CGDCONT=1,\"IP\",\"");
		strcat((char*)c->ConnectString2, *a);
		strcat((char*)c->ConnectString2, "\"^OK~");
		return;
	}
	if(c->ConnectString1[0] == '\0')
	{
		strcpy((char*)c->ConnectString1, "AT+CGDCONT=1,\"IP\",\"");
		strcat((char*)c->ConnectString1, *a);
		strcat((char*)c->ConnectString1, "\"^OK~");
		return;
	}

//	MessageBox(MAKEINTRESOURCE(IDS_NOAVAILABLESTRINGSFORPIN), "Error", MB_OK);

}






void CNicCPAppDlg::OnChangePin() 
{

	this->m_PINChanged = true;
}

void CNicCPAppDlg::OnChangeApn() 
{
	this->m_APNChanged = true;
}

void CNicCPAppDlg::OnChangeUsername() 
{
	this->m_UsernameChanged = true;
	
}

void CNicCPAppDlg::OnChangePassword() 
{
	this->m_PasswordChanged = true;
}

void CNicCPAppDlg::OnChangeSecret() 
{
	this->m_SecretChanged = TRUE;	
}


LRESULT CNicCPAppDlg::OnKillDebugpointer(WPARAM msg,   LPARAM  param)
{

	if(pDebugDlg)
	{
		pDebugDlg->keeprunning = false;
		delete pDebugDlg;
		pDebugDlg = NULL;
	}

	return 1;
}


LRESULT CNicCPAppDlg::OnDeviceChange(WPARAM nEventType, LPARAM dwData )
{
	CString out = "";

	{
		DEV_BROADCAST_HDR *pDev = (DEV_BROADCAST_HDR *)dwData;


		switch(nEventType)
		{

		case DBT_DEVICEARRIVAL :
			{
				DEV_BROADCAST_HANDLE		filter = {0};


				if(pDev->dbch_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
				{
					PDEV_BROADCAST_DEVICEINTERFACE p = (PDEV_BROADCAST_DEVICEINTERFACE)dwData;


   					if(!GetDeviceDescription(p->dbcc_name, DeviceName))
					{
						// failure, what to do...
						break;
					}


					if(   (strstr(DeviceName, "GlobeTrotter") > 0)  && (strstr(DeviceName, "Network") > 0)  && (strstr(DeviceName, "Scheduler") ==0)   )
					{
	  					out = "DBT_DEVICEARRIVAL "; 
   						out += "INTERFACE "; 
						out += DeviceName;

						if(m_hDevice == NULL)
						{
 
							m_hDevice = CreateFile(p->dbcc_name, MAXIMUM_ALLOWED  , 0, NULL, OPEN_EXISTING, 0, NULL);

							if(m_hDevice == INVALID_HANDLE_VALUE) 
							{
								doerror();
								break;
							}

							if( strstr(DeviceName, "HSxPA") > 0) 
								_7dot2 = TRUE;

							ZeroMemory(&filter,			sizeof(filter)); 
							filter.dbch_size			= sizeof(filter);
							filter.dbch_devicetype		= DBT_DEVTYP_HANDLE;
							filter.dbch_handle			= m_hDevice;
							hHandleNotification			= RegisterDeviceNotification(GetSafeHwnd(),  &filter,    DEVICE_NOTIFY_WINDOW_HANDLE);
							if(!hHandleNotification)
							{
								doerror();
							}

							CreateThread(NULL, 
											0, 
											&ConnectThread,    // thread function
											this,              // thread argument
											0,				   // creation option
											0);                // thread identifier

						}
					}
				}
			}
			break;

		case DBT_DEVICEREMOVECOMPLETE:
			{
				// we havent seen a  DBT_DEVICEREMOVECOMPLETE by HANDLE for the Ndis device, but we have for thebus driver, so this code is here
				// as a note that itc can happen, and is device dependent.  Whether this is Ndis vs WDM related, or class of device is unknown.

				if(pDev->dbch_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
				{
					PDEV_BROADCAST_DEVICEINTERFACE p = (PDEV_BROADCAST_DEVICEINTERFACE)dwData;

					if(GetDeviceDescription(p->dbcc_name, DeviceName))
					{
						if(   (strstr(DeviceName, "GlobeTrotter") > 0)  && (strstr(DeviceName, "Network") > 0)  && (strstr(DeviceName, "Scheduler") ==0)   )
						{
							out = "DBT_DEVICEREMOVECOMPLETE "; 
							out += "INTERFACE "; 
							out += DeviceName;

							CloseDevice();
						}
					}
				}

				else if(pDev->dbch_devicetype == DBT_DEVTYP_HANDLE)
				{
					PDEV_BROADCAST_HANDLE p = (PDEV_BROADCAST_HANDLE)dwData;

					// does the handle match
					if(p->dbch_handle == m_hDevice)
					{
						out = "DBT_DEVICEREMOVECOMPLETE "; 
						out += "HANDLE "; 
						// we are being asked to close the device, so close all handles, deregister, and return true;
						CloseDevice();
					}
				}	
			}
			break;

		case DBT_DEVICEQUERYREMOVE:
			{
				if(pDev->dbch_devicetype == DBT_DEVTYP_HANDLE)
				{
					PDEV_BROADCAST_HANDLE p = (PDEV_BROADCAST_HANDLE)dwData;

					// does the handle match
					if(p->dbch_handle == m_hDevice)
					{
						out = "DBT_DEVICEQUERYREMOVE "; 
						out += "HANDLE "; 
						// we are being asked to close the device, so close all handles, deregister, and return true;
						CloseDevice();
					}
				}	
			}	
			break;  

 
		case DBT_DEVICEQUERYREMOVEFAILED:
			{
//				out = "DBT_DEVICEQUERYREMOVEFAILED"; 

				if(pDev->dbch_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
				{
					PDEV_BROADCAST_DEVICEINTERFACE p = (PDEV_BROADCAST_DEVICEINTERFACE)dwData;

//					out += p->dbcc_name;
				}

				else if(pDev->dbch_devicetype == DBT_DEVTYP_HANDLE)
				{
					PDEV_BROADCAST_HANDLE p = (PDEV_BROADCAST_HANDLE)dwData;

				}	
			}
			break;

		case DBT_DEVICEREMOVEPENDING:
			{
//				out = "DBT_DEVICEREMOVEPENDING"; 

				if(pDev->dbch_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
				{
					PDEV_BROADCAST_DEVICEINTERFACE p = (PDEV_BROADCAST_DEVICEINTERFACE)dwData;
//					out += p->dbcc_name;

				}

				else if(pDev->dbch_devicetype == DBT_DEVTYP_HANDLE)
				{
					PDEV_BROADCAST_HANDLE p = (PDEV_BROADCAST_HANDLE)dwData;
				}
			}
			break;

		case DBT_CUSTOMEVENT:
			{
//				out = "DBT_CUSTOMEVENT"; 

				if(pDev->dbch_devicetype == DBT_DEVTYP_DEVICEINTERFACE)
				{
					PDEV_BROADCAST_DEVICEINTERFACE p = (PDEV_BROADCAST_DEVICEINTERFACE)dwData;

//					out += p->dbcc_name;
				}

				else if(pDev->dbch_devicetype == DBT_DEVTYP_HANDLE)
				{
					PDEV_BROADCAST_HANDLE p = (PDEV_BROADCAST_HANDLE)dwData;
				}
			}
			break;

		default:
			break;
		}

		if(pDebugDlg)
		{
			
			ResetEvent(pDebugDlg->traceEvent);

			out += "\n";

			UINT len = out.GetLength();
			if(len > 3)
			{

				for(UINT i =0 ; i < len ; i++)
				{
					pDebugDlg->m_EditTrace.SendMessage(WM_CHAR, out.GetAt(i), 0);
				}
					
				pDebugDlg->m_EditTrace.SendMessage(WM_CHAR, 13,0);
			}

			SetEvent(pDebugDlg->traceEvent);

		}


	}
	return 1;
}


void CNicCPAppDlg::CloseDevice(void)
{

	// thses should be NULL by now, but just in case
	if(hHandleNotification != NULL)
		UnregisterDeviceNotification(hHandleNotification);

	hHandleNotification = NULL;

	if(m_hDevice != NULL)
		CloseHandle(m_hDevice);

	m_hDevice = NULL;

	if(hFile && (hFile != INVALID_HANDLE_VALUE)) 
	{
		EnterCriticalSection(&CriticalSection);

		CloseHandle(hFile);
		keeprunning = false;
		hFile = NULL;

		LeaveCriticalSection(&CriticalSection);

		m_PINChanged = false;
		m_APNChanged = false;
		m_UsernameChanged = false;
		m_PasswordChanged = false;
		m_SecretChanged = false;

		//
		// blank the GUI
		//

		m_UserName = _T("");
		m_APNStr = _T("");
		m_PasswordStr = _T("");
		m_PINStr = _T("");
		m_SecretInt = 0;


		m_DisconnectCtl.EnableWindow(FALSE);
		m_ConnectCtl.EnableWindow(FALSE);
		m_AdvancedCtl.EnableWindow(FALSE);
		m_NetworkInfoCtl.EnableWindow(FALSE);
		m_APNCtl.EnableWindow(FALSE);
		m_PINCtl.EnableWindow(FALSE);
		m_PassWordCtl.EnableWindow(FALSE);
		m_UserNameCtl.EnableWindow(FALSE);
		m_StatusCtl.EnableWindow(FALSE);
		m_SecretCtl.EnableWindow(FALSE);

		if(pDebugDlg)
		{
			pDebugDlg->m_RawAtCtl.EnableWindow(FALSE);
			pDebugDlg->m_RawAtDataCtl.EnableWindow(FALSE);
		}

		UpdateData(FALSE);

		keeprunning = true;
	}
}



BOOL  CNicCPAppDlg::GetDeviceDescription(   LPTSTR DevPath,   LPTSTR OutBuffer)
{
    HDEVINFO                            hardwareDeviceInfo;
    SP_DEVICE_INTERFACE_DATA            deviceInterfaceData;
    SP_DEVINFO_DATA                     deviceInfoData;
    DWORD                               dwRegType, error;

    hardwareDeviceInfo = SetupDiCreateDeviceInfoList(NULL, NULL);
    if(INVALID_HANDLE_VALUE == hardwareDeviceInfo)
    {
        goto Error;
    }
    
    //
    // Enumerate devices of class
    //
    deviceInterfaceData.cbSize = sizeof(deviceInterfaceData);

    if(!SetupDiOpenDeviceInterface (hardwareDeviceInfo, DevPath, 0, &deviceInterfaceData))
	{
		doerror();
		goto Error;
	}
                                 
    deviceInfoData.cbSize = sizeof(deviceInfoData);
    if(!SetupDiGetDeviceInterfaceDetail (
            hardwareDeviceInfo,
            &deviceInterfaceData,
            NULL, // probing so no output buffer yet
            0, // probing so output buffer length of zero
            NULL,
            &deviceInfoData) && (error = GetLastError()) != ERROR_INSUFFICIENT_BUFFER)
    {
        goto Error;
    }
    //
    // Get the friendly name for this instance, if that fails
    // try to get the device description.
    //

    if(!SetupDiGetDeviceRegistryProperty(hardwareDeviceInfo, &deviceInfoData,
                                     SPDRP_FRIENDLYNAME,
                                     &dwRegType,
                                     (BYTE*) OutBuffer,
                                     MAX_PATH,
                                     NULL))
    {
        if(!SetupDiGetDeviceRegistryProperty(hardwareDeviceInfo, &deviceInfoData,
                                     SPDRP_DEVICEDESC,
                                     &dwRegType,
                                     (BYTE*) OutBuffer,
                                     MAX_PATH,
                                     NULL)){
            goto Error;
                                     
        }
        

    }

    SetupDiDestroyDeviceInfoList (hardwareDeviceInfo);
    return TRUE;

Error:

    error = GetLastError();
    SetupDiDestroyDeviceInfoList (hardwareDeviceInfo);
    return FALSE;
}

void CNicCPAppDlg::OnTimer(UINT nIDEvent) 
{

	// get the status and shove it in the window

	if(hFile && (hFile != INVALID_HANDLE_VALUE))
	{
		DWORD bytesback;
		GT_NDISGPRSStatus	status;


		if(DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_QUERY_STATUS, NULL, 0, &status, sizeof(GT_NDISGPRSStatus), &bytesback,NULL))
		{
			if(bytesback != sizeof(GT_NDISGPRSStatus))
			{
				m_StatusString = "Error getting ststus";
			}
			else
			{
				switch(status.Status)
				{
				case 0:
					m_StatusString = "Disconnected  \r\n";
					break;
				case 1:
					m_StatusString = "Connected  \r\n";
					break;
				case 2:
					m_StatusString = "Connect Open  \r\n";
					break;
				case 3:
					m_StatusString = "Connect Device  \r\n";
					break;
				case 4:
					m_StatusString = "Connect Authenticating  \r\n";
					break;
				case 5:
					m_StatusString = "Connect Authenticated  \r\n";
					break;
				case 6:
					m_StatusString = "Disconnecting  \r\n";
					break;
				case 7:
					m_StatusString = "Error  \r\n";
					break;
				case 8:
					m_StatusString = "Unknown  \r\n";
					break;
				default:
					m_StatusString = "Error  \r\n";
					break;


				}


				switch(status.Reason)
				{

				case 0:
					m_StatusString += "Normal";
					break;
				case 1:
					m_StatusString += "User initiated";
					break;
				case 2:
					m_StatusString += "Carrier lost";
					break;
				case 3:
					m_StatusString += "LCP Failed";
					break;
				case 4:
					m_StatusString += "PAP/CHAP Failed";
					break;
				case 5:
					m_StatusString += "IPCP Failed";
					break;
				case 6:
					m_StatusString += "No Carrier";
					break;
				default:
					m_StatusString += "Error";
					break;
				}

			
				this->m_StatusCtl.SetWindowText(m_StatusString);
			}
		}

		// on error, kill timer
		else
		{
			DWORD error = GetLastError();
		
			KillTimer(m_Timer);  

			if(error == 5)  // ACCESS IS DENIED, we get this when the NDIS driver is stopped, and the IOdevice returns DELETE PENDING
			{
				CloseDevice();
			}
		}
	}

	CDialog::OnTimer(nIDEvent);
}

