//
//
//Copyright (c) 2010 Option NV
//
#pragma once

#pragma pack(push)		/* push current alignment to stack */
#pragma pack(1)			/* set alignment to 1 byte boundary */


#ifndef __DRIVER_H_shared__
#define __DRIVER_H_shared__
/*	***************************************************************************************
	The following IOCTL's and structures are available in drivers: 
	- 5.0.x.x
	- 5.2.x.x
	**************************************************************************************/
#define GT_NDIS_GPRS_MAXLEN_GUID			48
#define	MAX_CONNECT_STRING_LENGTH			256

#define IOCTL_GT_NDIS_GPRS_QUERY_STATUS			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0x80D,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_QUERY_STATS			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0x80E,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_GT_NDIS_GPRS_GET_NET_CFG_ID		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA10 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_SET_TCPWINDOWSIZE	CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA11 , METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_GT_NDIS_GPRS_GET_DRIVERTYPE		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xD02 , METHOD_BUFFERED, FILE_ANY_ACCESS)


typedef struct _GT_NDISGPRSIpAddr
{
	UCHAR a;
	UCHAR b;
	UCHAR c;
	UCHAR d;
} GT_NDISGPRSIpAddr;

// GPRS connection statistics 
typedef struct _GT_NDISGPRSStats
{
	ULONG BytesXmited;
	ULONG BytesRcved;
	ULONG FramesXmited;
	ULONG FramesRcved;
	ULONG Errors;
	ULONG ConnectDuration;		// milliseconds 
} GT_NDISGPRSStats;

typedef enum
{
	GT_NDIS_GPRS_DRIVERTYPE_50 = 0,		// 5.0.x.x drivers
	GT_NDIS_GPRS_DRIVERTYPE_51,			// 5.1.x.x drivers
	GT_NDIS_GPRS_DRIVERTYPE_52,			// 5.2.x.x drivers
} GT_NDISGPRSDriverTypeCode;

typedef struct _GT_NDISGPRSDriverType
{
	GT_NDISGPRSDriverTypeCode DriverTypeCode;
} GT_NDISGPRSDriverType;

#endif

#ifndef __DRIVER_H_52__
#define __DRIVER_H_52__
/*	***************************************************************************************
	The following IOCTL's and structures are specifically for 5.2.x.x drivers
 	****************************************************************************************/
#define IOCTL_GT_NDIS_GPRS_SET_LINK_DOWN		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xD00 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_SET_LINK_UP			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xD01 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_RAW_AT_READ			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xD03 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_GPRS_RAW_AT_WRITE			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xD04 , METHOD_BUFFERED, FILE_ANY_ACCESS)


// GPRS connection status 
typedef enum
{
	GT_NDIS_GPRS_DISCONNECTED52 = 0,	// Link is DOWN. Connection disconnected.
	GT_NDIS_GPRS_LINK_UP52,				// Link is UP. Connection being established.
	GT_NDIS_GPRS_CONNECTED52,			// Link is UP. Connection established.
} GT_NDISGPRSStatusCode52;

typedef struct _ConfigData52
{
	GT_NDISGPRSIpAddr 	IpAddress1;
	GT_NDISGPRSIpAddr 	DNSAddress1;
	GT_NDISGPRSIpAddr 	DNSAddress2;
	GT_NDISGPRSIpAddr 	NBNSAddress1;
	GT_NDISGPRSIpAddr 	NBNSAddress2;
	ULONG				ulLinkSpeed;
} ConfigData52, *PConfigData52;

typedef struct _GT_NDISGPRSStatus52
{
	GT_NDISGPRSStatusCode52 Status;
} GT_NDISGPRSStatus52;
#endif

#pragma pack(pop)			/* restore original alignment from stack */

