#!/bin/sh

# Prepare the correct hso version

DIRNAME=`dirname $0`
echo $1
KERNELVER=`echo $1 | sed "s/^\([0-9]*\.[0-9]*\.[0-9]*\).*/\1/g"`
echo $KERNELVER
KERNELVER=`echo $KERNELVER | sed "s/^\(3\.[0-9]*\).*/\1/g"`
echo $KERNELVER

if [ -e $DIRNAME/versions/hso-v$KERNELVER.c ]; then
        #Workaround for the DKMS bug where the pre_build script is run from the
        #source folder
        DIRNAME=`echo $DIRNAME | sed "s|/source$|/build|"`
        cp $DIRNAME/versions/hso-v$KERNELVER.c $DIRNAME/hso.c
        echo "Found driver for kernel version $KERNELVER and copied it to $DIRNAME/"
else
        echo "ERROR: Can't find driver for kernel version $1 in $DIRNAME"
	exit -1
fi

